<?php
/**
 * 2007-2025 Your Company
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License (AFL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * https://opensource.org/licenses/AFL-3.0
 *
 * @author    Net-assembly
 * @copyright 2007-2026 Net-assembly
 * @license   https://opensource.org/licenses/AFL-3.0 Academic Free License (AFL 3.0)
 */
if (!defined('_PS_VERSION_')) {
    exit;
}

/**
 * Stores mappings between PrestaShop payment modules and cash payment ids.
 */
class PaymentMatches extends ObjectModel
{
    /** @var int */
    public $id_ns_paiement;

    /** @var int */
    public $cash_payment_id;

    /** @var int */
    public $id_payment;

    /** @var int */
    public $id_shop;

    /**
     * @see ObjectModel::$definition
     */
    public static $definition = [
        'table' => 'ns_paiement',
        'primary' => 'id_ns_paiement',
        'multilang' => false,
        'fields' => [
            'cash_payment_id' => ['type' => self::TYPE_INT, 'validate' => 'isInt', 'required' => true],
            'id_payment' => ['type' => self::TYPE_INT, 'validate' => 'isInt', 'required' => true],
            'id_shop' => ['type' => self::TYPE_INT, 'validate' => 'isInt', 'required' => true],
        ],
    ];

    /**
     * @param int $id_shop
     *
     * @return array<int, array<string, mixed>>
     */
    public static function getMatches($id_shop)
    {
        $sql = 'SELECT sample.`id_shop`, sample.`id_ns_paiement`, sample.`id_payment`, sample.`cash_payment_id`
            FROM `' . _DB_PREFIX_ . 'ns_paiement` sample
            WHERE sample.`id_shop` = ' . (int) $id_shop;

        return Db::getInstance()->executeS($sql);
    }

    /**
     * @param int $id_payment
     *
     * @return string
     */
    public static function getPaymentName($id_payment)
    {
        $module = Module::getInstanceById((int) $id_payment);

        return $module ? (string) $module->displayName : '';
    }

    /**
     * @param int $id_payment
     *
     * @return int|null
     */
    public static function getPaymentMethod($id_payment)
    {
        $id_shop = (int) Context::getContext()->shop->id;

        $result = Db::getInstance()->getRow(
            'SELECT sample.`cash_payment_id`
            FROM `' . _DB_PREFIX_ . 'ns_paiement` sample
            WHERE sample.`id_payment` = ' . (int) $id_payment . '
              AND sample.`id_shop` = ' . (int) $id_shop
        );

        if (!is_array($result) || !isset($result['cash_payment_id'])) {
            return null;
        }

        return (int) $result['cash_payment_id'];
    }
}
