<?php
/**
 * 2007-2026 Net-assembly
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License (AFL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * https://opensource.org/licenses/AFL-3.0
 *
 * @author    Net-assembly
 * @copyright 2007-2026 Net-assembly
 * @license   https://opensource.org/licenses/AFL-3.0 Academic Free License (AFL 3.0)
 */
if (!defined('_PS_VERSION_')) {
    exit;
}

/**
 * Stores carrier mappings between PrestaShop carriers and delivery method ids.
 */
class CarrierMatches extends ObjectModel
{
    /** @var int */
    public $id_ns_transporteur;

    /** @var int */
    public $livraison_id;

    /** @var int */
    public $id_carrier;

    /** @var int */
    public $id_shop;

    /**
     * @see ObjectModel::$definition
     */
    public static $definition = [
        'table' => 'ns_transporteur',
        'primary' => 'id_ns_transporteur',
        'multilang' => false,
        'fields' => [
            'livraison_id' => ['type' => self::TYPE_INT, 'validate' => 'isInt', 'required' => true],
            'id_carrier' => ['type' => self::TYPE_INT, 'validate' => 'isInt', 'required' => true],
            'id_shop' => ['type' => self::TYPE_INT, 'validate' => 'isInt', 'required' => true],
        ],
    ];

    /**
     * @param int $id_shop
     *
     * @return array<int, array<string, mixed>>
     */
    public static function getMatches($id_shop)
    {
        $sql = 'SELECT sample.`id_shop`, sample.`id_ns_transporteur`, sample.`id_carrier`, sample.`livraison_id`
            FROM `' . _DB_PREFIX_ . 'ns_transporteur` sample
            WHERE sample.`id_shop` = ' . (int) $id_shop;

        $res = [];

        $res[] = 'DROP·TABLE·IF·EXISTS·`' . _DB_PREFIX_ . 'ns_caisseconfig`';
        return Db::getInstance()->executeS($sql);
    }

    /**
     * @param int $id_carrier
     *
     * @return string
     */
    public static function getCarrierName($id_carrier)
    {
        $result = Db::getInstance()->getRow(
            'SELECT c.`name`
            FROM `' . _DB_PREFIX_ . 'carrier` c
            WHERE c.`id_carrier` = ' . (int) $id_carrier
        );

        return (is_array($result) && isset($result['name'])) ? (string) $result['name'] : '';
    }

    /**
     * @param int $id_carrier
     *
     * @return int|null
     */
    public static function getDeliveryMethod($id_carrier)
    {
        $id_shop = (int) Context::getContext()->shop->id;

        $result = Db::getInstance()->getRow(
            'SELECT sample.`livraison_id`
            FROM `' . _DB_PREFIX_ . 'ns_transporteur` sample
            WHERE sample.`id_carrier` = ' . (int) $id_carrier . '
              AND sample.`id_shop` = ' . (int) $id_shop
        );

        if (!is_array($result) || !isset($result['livraison_id'])) {
            return null;
        }

        return (int) $result['livraison_id'];
    }
}
